/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.client.screen.base;

import com.lazrproductions.lazrslib.client.screen.base.BlitCoordinates;
import net.minecraft.util.Mth;
import org.joml.Vector2i;

public class ScreenRect {
    int startX;
    int startY;
    int endX;
    int endY;

    public ScreenRect(int fromX, int fromY, int toX, int toY) {
        int f;
        this.startX = fromX;
        this.startY = fromY;
        this.endX = toX;
        this.endY = toY;
        if (this.startY > this.endY) {
            f = this.endY;
            this.endY = this.startY;
            this.startY = f;
        }
        if (this.startX > this.endX) {
            f = this.endX;
            this.endX = this.startX;
            this.startX = f;
        }
    }

    public static ScreenRect fromWidth(int x, int y, int width, int height) {
        return new ScreenRect(x, y, x + width, y + height);
    }

    public static ScreenRect fromWidthCentered(int x, int y, int width, int height) {
        return new ScreenRect(x - width / 2, y - height / 2, x + width / 2, y + height / 2);
    }

    public int getFromX() {
        return this.startX;
    }

    public int getFromY() {
        return this.startY;
    }

    public int getToX() {
        return this.endX;
    }

    public int getToY() {
        return this.endY;
    }

    public int getWidth() {
        return this.getToX() - this.getFromX();
    }

    public int getHeight() {
        return this.getToY() - this.getFromY();
    }

    public Vector2i getTopLeft() {
        return new Vector2i(this.getFromX(), this.getFromY());
    }

    public Vector2i getTopRight() {
        return new Vector2i(this.getToX(), this.getFromY());
    }

    public Vector2i getBottomLeft() {
        return new Vector2i(this.getFromX(), this.getToY());
    }

    public Vector2i getBottomRight() {
        return new Vector2i(this.getToX(), this.getToY());
    }

    public Vector2i getCenter() {
        return new Vector2i(Mth.m_14143_((float)(this.getFromX() + this.getWidth() / 2)), Mth.m_14143_((float)(this.getFromY() + this.getHeight() / 2)));
    }

    public boolean positionEnvlopes(double x, double y) {
        return x >= (double)this.getFromX() && x <= (double)this.getToX() && y >= (double)this.getFromY() && y <= (double)this.getToY();
    }

    public boolean positionEnvlopes(float x, float y) {
        return x >= (float)this.getFromX() && x <= (float)this.getToX() && y >= (float)this.getFromY() && y <= (float)this.getToY();
    }

    public boolean positionEnvlopes(int x, int y) {
        return x >= this.getFromX() && x <= this.getToX() && y >= this.getFromY() && y <= this.getToY();
    }

    public BlitCoordinates toBlitCoordinates() {
        return new BlitCoordinates(this.getFromX(), this.getFromY(), this.getWidth(), this.getHeight());
    }
}

